<?php
// app/Models/Role.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    protected $fillable = ['name', 'description', 'is_default'];
    
    public function permissions()
    {
        return $this->belongsToMany(Permission::class, 'role_permissions');
    }
    
    public function admins()
    {
        return $this->belongsToMany(Admin::class, 'admin_roles');
    }
    
    public function hasPermission($permission)
    {
        return $this->permissions->contains('slug', $permission);
    }
}