<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Rfq extends Model
{
    protected $fillable = ['buyer_id', 'style', 'quantity', 'fabric_id', 'gsm', 'wastage_percent', 'rate', 'delivery_date', 'image', 'status'];

    public function buyer() {
        return $this->belongsTo(Buyer::class);
    }


    public function fabric() {
        return $this->belongsTo(InformationLibrary::class, 'fabric_id');
    }

    public function revisions() {
        return $this->hasMany(RfqRevision::class);
    }

    public function accessories() {
        return $this->hasMany(RfqAccessory::class);
    }
}