<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Info\Brand;
use App\Models\Info\ItemDescription;
use App\Models\Info\SizeRange;
use App\Models\Info\Color;
use App\Models\Info\FabricComposition;
use App\Models\Info\FabricType;
use App\Models\Info\YarnCount;
use App\Models\Info\FabricWeight;
use App\Models\Info\PortOfLanding;
use App\Models\Info\CountryOfOrigin;
use App\Models\Info\PortOfDischarge;
use App\Models\Info\FinalDestination;
use App\Models\Info\DeliveryTerm;
use App\Models\Info\ShipmentMode;
use App\Models\Buyer;

use App\Models\Inquiry;

class Inquiry extends Model
{
    use HasFactory;

    protected $fillable = [
        'buyer_id',
        'brand_id',
        'purchase_order_no',
        'style_number',
        'item_no',
        'item_description_id',
        'size_range_id',
        'color_id',
        'order_quantity',
        'fabric_composition_id',
        'fabric_type_id',
        'yarn_count_id',
        'fabric_weight_id',
        'shipment_date',
        'target_price',
        'port_of_landing_id',
        'country_of_origin_id',
        'port_of_discharge_id',
        'final_destination_id',
        'delivery_term_id',
        'shipment_mode_id',
        'images',
    ];

    protected $casts = [
        'shipment_date' => 'date',
        'target_price' => 'decimal:2',
    ];

    // Relationships
     public function quotation() {
        return $this->belongsTo(Quotation::class);
    }
    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function itemDescription()
    {
        return $this->belongsTo(ItemDescription::class);
    }

    public function sizeRange()
    {
        return $this->belongsTo(SizeRange::class);
    }

    public function color()
    {
        return $this->belongsTo(Color::class);
    }

    public function fabricComposition()
    {
        return $this->belongsTo(FabricComposition::class);
    }

    public function fabricType()
    {
        return $this->belongsTo(FabricType::class);
    }

    public function yarnCount()
    {
        return $this->belongsTo(YarnCount::class);
    }

    public function fabricWeight()
    {
        return $this->belongsTo(FabricWeight::class);
    }

    public function portOfLanding()
    {
        return $this->belongsTo(PortOfLanding::class);
    }

    public function countryOfOrigin()
    {
        return $this->belongsTo(CountryOfOrigin::class);
    }

    public function portOfDischarge()
    {
        return $this->belongsTo(PortOfDischarge::class);
    }

    public function finalDestination()
    {
        return $this->belongsTo(FinalDestination::class);
    }

    public function deliveryTerm()
    {
        return $this->belongsTo(DeliveryTerm::class);
    }

    public function shipmentMode()
    {
        return $this->belongsTo(ShipmentMode::class);
    }
      public function buyer() {
        return $this->belongsTo(Buyer::class);
    }

}
