<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneratedDocument extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_confirmation_id',
        'document_type',
        'file_name',
        'file_path',
        'file_size',
        'generation_data',
        'generated_by'
    ];

    protected $casts = [
        'generation_data' => 'array'
    ];

    public function orderConfirmation()
    {
        return $this->belongsTo(OrderConfirmation::class);
    }

    public function generator()
    {
        return $this->belongsTo(User::class, 'generated_by');
    }

    public function emailLogs()
    {
        return $this->hasMany(EmailLog::class);
    }
}