<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmailLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'generated_document_id',
        'recipient_email',
        'recipient_name',
        'subject',
        'message',
        'status',
        'sent_at',
        'sent_by'
    ];

    protected $casts = [
        'sent_at' => 'datetime'
    ];

    public function document()
    {
        return $this->belongsTo(GeneratedDocument::class, 'generated_document_id');
    }

    public function sender()
    {
        return $this->belongsTo(User::class, 'sent_by');
    }
}