<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cost extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'amount',
        'other_cost_id',
    ];

    /**
     * Get the other cost category that owns the cost.
     */
    public function otherCost()
    {
        return $this->belongsTo(OtherCost::class);
    }
}

