<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CartonDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'shipment_id',
        'carton_number',
        'quantity',
        'gross_weight',
        'net_weight',
        'volume',
        'description'
    ];

    protected $casts = [
        'gross_weight' => 'decimal:2',
        'net_weight' => 'decimal:2',
        'volume' => 'decimal:3',
    ];

    public function shipment(): BelongsTo
    {
        return $this->belongsTo(Shipment::class);
    }
}