<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Buyer extends Model
{
    protected $fillable = [
        'company_name',
        'contact_person',
        'email',
        'vat',
        'fax',
        'phone',
        'bank_id',
        'address',
        'country'
    ];
    
  public function orders()
    {
        return $this->hasMany(Order::class);
    }

    public function bank()
    {
        return $this->belongsTo(\App\Models\Bank::class, 'bank_id');
    }

    public function banks()
    {
        return $this->hasMany(\App\Models\Bank::class, 'buyer_id');
    }

    // Add these new relationships for payment module
    public function advancePayments()
    {
        return $this->hasMany(AdvancePayment::class);
    }

    public function bankInvoices()
    {
        return $this->hasMany(BankInvoice::class);
    }

    public function ledger()
    {
        return $this->hasOne(PaymentLedger::class);
    }

}

