<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BlogPost extends Model {
    protected $fillable = ['title', 'slug', 'short_description', 'content', 'image', 'author', 'category_id'];

    public function category() {
        return $this->belongsTo(BlogCategory::class);
    }

    public function comments() {
        return $this->hasMany(BlogComment::class, 'post_id')->whereNull('parent_id')->orderBy('created_at', 'desc');
    }
}
