<?php
namespace App\Models;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Bank extends Model
{
    use HasFactory;

    protected $fillable = [
        'account_name','account_no','iban','swift',
        'bank_name','bank_address','correspondent_bank',
        'correspondent_swift','correspondent_account'
    ];

    // optional: buyers that use this bank as selected bank
    public function buyers()
    {
        return $this->hasMany(\App\Models\Buyer::class, 'bank_id');
    }
}
