<?php
// app/Models/AuditLog.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model
{
    protected $fillable = [
        'admin_id', 'action', 'module', 'description', 
        'ip_address', 'user_agent', 'old_values', 'new_values'
    ];
    
    protected $casts = [
        'old_values' => 'array',
        'new_values' => 'array'
    ];
    
    public function admin()
    {
        return $this->belongsTo(Admin::class);
    }
}