<?php
// app/Models/Admin.php
namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Admin extends Authenticatable
{
    use Notifiable;

    protected $guard = 'admin';

    protected $fillable = [
        'name', 'email', 'password', 'profile_image',
    ];

    protected $hidden = [
        'password',
    ];
    
    // 🔥 YEH NAYA CODE ADD KAREIN - START
    public function roles()
    {
        return $this->belongsToMany(Role::class, 'admin_roles');
    }
    
    public function auditLogs()
    {
        return $this->hasMany(AuditLog::class);
    }
    
    public function hasPermission($permission)
    {
        if ($this->isSuperAdmin()) {
            return true;
        }
        
        foreach ($this->roles as $role) {
            if ($role->hasPermission($permission)) {
                return true;
            }
        }
        
        return false;
    }
    
    public function hasRole($role)
    {
        return $this->roles->contains('name', $role);
    }
    
    public function isSuperAdmin()
    {
        return $this->hasRole('superadmin');
    }
    
    public function assignRole($role)
    {
        if (is_string($role)) {
            $role = Role::where('name', $role)->first();
        }
        
        return $this->roles()->syncWithoutDetaching($role);
    }
    // 🔥 YEH NAYA CODE ADD KAREIN - END
}