<?php
// app/Http/Middleware/CheckPermission.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckPermission
{
    public function handle(Request $request, Closure $next, $permission)
    {
        if (auth('admin')->check() && auth('admin')->user()->hasPermission($permission)) {
            return $next($request);
        }
        
        abort(403, 'Unauthorized action.');
    }
}