<?php

namespace App\Http\Controllers;

use App\Models\YarnType;
use Illuminate\Http\Request;

class YarnTypeController extends Controller
{
    public function index()
    {
        $yarnTypes = YarnType::all();
        return view("admin.information_library.yarn_types.index", compact("yarnTypes"));
    }

    public function create()
    {
        return view("admin.information_library.yarn_types.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "price" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        YarnType::create($request->all());

        return redirect()->route("admin.yarn_types.index")->with("success", "Yarn Type created successfully.");
    }

 

    public function edit(YarnType $yarnType)
    {
        return view("admin.information_library.yarn_types.edit", compact("yarnType"));
    }

    public function update(Request $request, YarnType $yarnType)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "price" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $yarnType->update($request->all());

        return redirect()->route("admin.yarn_types.index")->with("success", "Yarn Type updated successfully.");
    }

    public function destroy(YarnType $yarnType)
    {
        $yarnType->delete();

        return redirect()->route("admin.yarn_types.index")->with("success", "Yarn Type deleted successfully.");
    }
}


