<?php

namespace App\Http\Controllers;

use App\Models\Seller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;

class SellerController extends Controller
{
    public function index() {
        $sellers = Seller::all();
        return view('admin.sellers.index', compact('sellers'));
    }

    public function create() {
        return view('admin.sellers.create');
    }

    public function store(Request $request) {
        $data = $request->validate([
            'company_name' => 'required|string',
            'plot' => 'nullable|string',
            'road' => 'nullable|string',
            'avenue' => 'nullable|string',
            'telephone' => 'nullable|string',
            'vat' => 'nullable|string',
            'image1' => 'nullable|image|max:4048',
            'image2' => 'nullable|image|max:4048',
            'image3' => 'nullable|image|max:4048',
            'image4' => 'nullable|image|max:4048',
        ]);

        for($i=1; $i<=4; $i++){
            if($request->hasFile("image$i")){
                $file = $request->file("image$i");
                $filename = time().'_'.$i.'.'.$file->getClientOriginalExtension();
                $file->move(public_path('sellers'), $filename);
                $data["image$i"] = 'sellers/'.$filename; // yeh DB me save hoga
            }
        }

        Seller::create($data);
        return redirect()->route('admin.sellers.index')->with('success','Seller added successfully');
    }

    public function edit(Seller $seller) {
        return view('admin.sellers.edit', compact('seller'));
    }

    public function update(Request $request, Seller $seller) {
        $data = $request->validate([
            'company_name' => 'required|string',
            'plot' => 'nullable|string',
            'road' => 'nullable|string',
            'avenue' => 'nullable|string',
            'telephone' => 'nullable|string',
            'vat' => 'nullable|string',
            'image1' => 'nullable|image|max:4048',
            'image2' => 'nullable|image|max:4048',
            'image3' => 'nullable|image|max:4048',
            'image4' => 'nullable|image|max:4048',
        ]);

        for($i=1; $i<=4; $i++){
            if($request->hasFile("image$i")){
                // delete purani file
                if($seller["image$i"] && File::exists(public_path($seller["image$i"]))){
                    File::delete(public_path($seller["image$i"]));
                }

                $file = $request->file("image$i");
                $filename = time().'_'.$i.'.'.$file->getClientOriginalExtension();
                $file->move(public_path('sellers'), $filename);
                $data["image$i"] = 'sellers/'.$filename;
            }
        }

        $seller->update($data);
        return redirect()->route('admin.sellers.index')->with('success','Seller updated successfully');
    }

    public function show(Seller $seller)
    {
        return view('admin.sellers.show', compact('seller'));
    }
    public function destroy(Seller $seller) {
        for($i=1;$i<=4;$i++){
            if($seller["image$i"] && File::exists(public_path($seller["image$i"]))){
                File::delete(public_path($seller["image$i"]));
            }
        }
        $seller->delete();
        return back()->with('success','Seller deleted successfully');
    }
}
