<?php
namespace App\Http\Controllers;

use App\Models\Rfq;
use App\Models\RfqRevision;
use Illuminate\Http\Request;

class RfqRevisionController extends Controller
{
    // Show the quotation form (Rev 1, Rev 2)
    public function create(Rfq $rfq)
    {
        $accessoriesCost = $rfq->accessories->sum(function ($item) {
            return $item->rate * $item->quantity;
        });

        return view('admin.rfqs.quotation.create', compact('rfq', 'accessoriesCost'));
    }

    // Save the quotation revision to DB
    public function store(Request $request, Rfq $rfq)
    {
        $validated = $request->validate([
            'revision_no' => 'required|string',
            'fabric_cost' => 'required|numeric',
            'accessories_cost' => 'nullable|numeric',
            'other_costs' => 'nullable|numeric',
            'overhead_percent' => 'nullable|numeric',
            'margin_percent' => 'nullable|numeric',
            'final_price' => 'required|numeric',
        ]);

        $validated['rfq_id'] = $rfq->id;

        RfqRevision::create($validated);

return redirect()->route('admin.rfqs.quotation.create', ['rfq' => $rfq->id])
                 ->with('success', 'Quotation revision saved.');
    }
}
