<?php

namespace App\Http\Controllers;

use App\Models\Rfq;
use App\Models\Buyer;
use App\Models\InformationLibrary;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class RfqController extends Controller
{
    public function index()
    {
        $rfqs = Rfq::with(['buyer', 'fabric'])->latest()->paginate(10);
        return view('admin.rfqs.index', compact('rfqs'));
    }

    public function create()
    {
        $buyers = Buyer::all();
        $fabrics = InformationLibrary::where('type', 'yarn')->get();
        return view('admin.rfqs.create', compact('buyers', 'fabrics'));
    }

    public function getFabricDetails($id)
{
    $fabric = \App\Models\InformationLibrary::findOrFail($id);

    return response()->json([
        'gsm' => $fabric->gsm,
        'wastage_percent' => $fabric->wastage_percent,
        'rate' => $fabric->rate,
    ]);
}

    public function store(Request $request)
    {

        $validated = $request->validate([
            'buyer_id' => 'required|exists:buyers,id',
            'style' => 'required|string',
            'quantity' => 'required|integer|min:1',
            'fabric_id' => 'required|exists:information_libraries,id',
            'delivery_date' => 'nullable|date',
              'gsm' => 'nullable|string',
             'wastage_percent' => 'nullable|numeric',
            'rate' => 'nullable|numeric',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'status' => 'required|in:draft,submitted',
        ]);

        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('rfq_images', 'public');
            $validated['image'] = $imagePath;
        }

        Rfq::create($validated);

        return redirect()->route('admin.rfqs.index')->with('success', 'RFQ created successfully.');
    }

    public function show(Rfq $rfq)
    {
        return view('admin.rfqs.show', compact('rfq'));
    }

    public function edit(Rfq $rfq)
    {
        $buyers = Buyer::all();
        $fabrics = InformationLibrary::where('type', 'yarn')->get();
        return view('admin.rfqs.edit', compact('rfq', 'buyers', 'fabrics'));
    }

    public function update(Request $request, Rfq $rfq)
    {
        $validated = $request->validate([
            'buyer_id' => 'required|exists:buyers,id',
            'style' => 'required|string',
            'quantity' => 'required|integer|min:1',
            'fabric_id' => 'required|exists:information_libraries,id',
            'delivery_date' => 'nullable|date',
            'gsm' => 'nullable|string',
            'wastage_percent' => 'nullable|numeric',
             'rate' => 'nullable|numeric',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif',
            'status' => 'required|in:draft,submitted',
        ]);

        if ($request->hasFile('image')) {
            $imagePath = $request->file('image')->store('rfq_images', 'public');
            $validated['image'] = $imagePath;
        }

        $rfq->update($validated);

        return redirect()->route('admin.rfqs.index')->with('success', 'RFQ updated successfully.');
    }

    public function destroy(Rfq $rfq)
    {
        $rfq->delete();
        return redirect()->route('admin.rfqs.index')->with('success', 'RFQ deleted successfully.');
    }
}



