<?php

namespace App\Http\Controllers;

use App\Models\Rfq;
use App\Models\RfqAccessory;
use Illuminate\Http\Request;

class RfqAccessoryController extends Controller
{
    /**
     * Show the form to create an accessory for a given RFQ.
     */
    public function create(Rfq $rfq)
    {
        return view('admin.rfqs.accessories.create', compact('rfq'));
    }

    /**
     * Store a newly created accessory.
     */
    public function store(Request $request, Rfq $rfq)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'quantity' => 'required|numeric|min:0',
            'rate' => 'required|numeric|min:0',
        ]);

        $validated['total'] = $validated['quantity'] * $validated['rate'];
        $validated['rfq_id'] = $rfq->id;

        RfqAccessory::create($validated);

        return redirect()->route('admin.rfqs.quotation.create', $rfq->id)
                         ->with('success', 'Accessory added successfully.');
    }
}
