<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Quotation;
use App\Models\OrderConfirmation;

class ReportController extends Controller
{
    public function dashboard()
    {
        // Get quote data
        $totalQuotes = Quotation::count();
        $wonQuotes = Quotation::where('status', 'won')->count();
        $lostQuotes = Quotation::where('status', 'lost')->count();
        $pendingQuotes = Quotation::where('status', 'pending')->count();
        $winRate = $totalQuotes > 0 ? ($wonQuotes / $totalQuotes) * 100 : 0;
        
        // Get profit margin data
        $wonQuotesData = Quotation::where('status', 'won')->get();
        $totalRevenue = $wonQuotesData->sum('quoted_price');
        $totalCost = $wonQuotesData->sum('calculated_total_cost');
        $totalProfit = $totalRevenue - $totalCost;
        $avgMargin = $totalCost > 0 ? ($totalProfit / $totalCost) * 100 : 0;
        
        // Get shipment data
        $totalOrders = OrderConfirmation::count();
        $deliveredOrders = OrderConfirmation::where('status', 'delivered')->count();
        $shippedOrders = OrderConfirmation::where('status', 'shipped')->count();
        $overdueOrders = OrderConfirmation::where('delivery_date', '<', now())
            ->whereNotIn('status', ['delivered', 'cancelled'])
            ->count();
        $onTimeRate = $totalOrders > 0 ? ($deliveredOrders / $totalOrders) * 100 : 0;

        return view('admin.reports.dashboard', compact(
            'totalQuotes', 
            'wonQuotes', 
            'lostQuotes', 
            'pendingQuotes', 
            'winRate',
            'wonQuotesData',
            'totalRevenue',
            'totalCost',
            'totalProfit',
            'avgMargin',
            'totalOrders',
            'deliveredOrders',
            'shippedOrders',
            'overdueOrders',
            'onTimeRate'
        ));
    }
    
    public function quoteAnalysis() 
    {
        $totalQuotes = Quotation::count();
        $wonQuotes = Quotation::where('status', 'won')->count();
        $lostQuotes = Quotation::where('status', 'lost')->count();
        $pendingQuotes = Quotation::where('status', 'pending')->count();
        $winRate = $totalQuotes > 0 ? ($wonQuotes / $totalQuotes) * 100 : 0;
        
        return view('admin.reports.quote-analysis', compact(
            'totalQuotes', 
            'wonQuotes', 
            'lostQuotes', 
            'pendingQuotes', 
            'winRate'
        ));
    }
    
    public function profitMargin()
    {
        $wonQuotesData = Quotation::where('status', 'won')->get();
        
        $totalRevenue = $wonQuotesData->sum('quoted_price');
        $totalCost = $wonQuotesData->sum('calculated_total_cost');
        $totalProfit = $totalRevenue - $totalCost;
        $avgMargin = $totalCost > 0 ? ($totalProfit / $totalCost) * 100 : 0;
        
        return view('admin.reports.profit-margin', compact(
            'wonQuotesData',
            'totalRevenue', 
            'totalCost', 
            'totalProfit', 
            'avgMargin'
        ));
    }
    
    public function shipmentPerformance()
    {
        $totalOrders = OrderConfirmation::count();
        $deliveredOrders = OrderConfirmation::where('status', 'delivered')->count();
        $shippedOrders = OrderConfirmation::where('status', 'shipped')->count();
        $overdueOrders = OrderConfirmation::where('delivery_date', '<', now())
            ->whereNotIn('status', ['delivered', 'cancelled'])
            ->count();
            
        $onTimeRate = $totalOrders > 0 ? ($deliveredOrders / $totalOrders) * 100 : 0;
        
        return view('admin.reports.shipment-performance', compact(
            'totalOrders', 
            'deliveredOrders', 
            'shippedOrders', 
            'overdueOrders', 
            'onTimeRate'
        ));
    }
}