<?php

namespace App\Http\Controllers;

use App\Models\RFQs;
use App\Models\Info\ItemDescription;
use App\Models\Info\Brand;
use App\Models\Info\SizeRange;
use App\Models\Info\Color;
use App\Models\Info\FabricComposition;
use App\Models\Info\FabricType;
use App\Models\Info\YarnCount;
use App\Models\Info\FabricWeight;
use App\Models\Info\PortOfLanding;
use App\Models\Info\CountryOfOrigin;
use App\Models\Info\PortOfDischarge;
use App\Models\Info\FinalDestination;
use App\Models\Info\DeliveryTerm;
use App\Models\Info\ShipmentMode;
use App\Models\Info\PaymentTerm;
use App\Models\Info\PaymentMode;
use App\Models\Buyer;

use Illuminate\Http\Request;

class RFQsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $rfqs = RFQs::with([
            'itemDescription', 'brand', 'sizeRange', 'color', 
            'fabricComposition', 'fabricType', 'yarnCount', 'fabricWeight',
            'portOfLanding', 'countryOfOrigin', 'portOfDischarge', 'finalDestination',
            'deliveryTerm', 'shipmentMode', 'paymentTerm', 'paymentMode', 'buyer'
        ])->latest()->paginate(10);
        return view('admin.rfq.index', compact('rfqs'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $buyer = Buyer::all();
        $itemDescriptions = ItemDescription::all();
        $brands = Brand::all();
        $sizeRanges = SizeRange::all();
        $colors = Color::all();
        $fabricCompositions = FabricComposition::all();
        $fabricTypes = FabricType::all();
        $yarnCounts = YarnCount::all();
        $fabricWeights = FabricWeight::all();
        $portOfLandings = PortOfLanding::all();
        $countryOfOrigins = CountryOfOrigin::all();
        $portOfDischarges = PortOfDischarge::all();
        $finalDestinations = FinalDestination::all();
        $deliveryTerms = DeliveryTerm::all();
        $shipmentModes = ShipmentMode::all();
        $paymentTerms = PaymentTerm::all();
        $paymentModes = PaymentMode::all();

        return view('admin.rfq.create', compact(
            'itemDescriptions', 'brands', 'sizeRanges', 'colors',
            'fabricCompositions', 'fabricTypes', 'yarnCounts', 'fabricWeights',
            'portOfLandings', 'countryOfOrigins', 'portOfDischarges', 'finalDestinations',
            'deliveryTerms', 'shipmentModes', 'paymentTerms', 'paymentModes', 'buyer'
        ));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'buyer_id' => 'required|exists:buyers,id',
            'item_description_id' => 'required|exists:item_descriptions,id',
            'brand_id' => 'nullable|exists:brands,id',
            'size_range_id' => 'required|exists:size_ranges,id',
            'color_id' => 'required|exists:colors,id',
            'fabric_composition_id' => 'required|exists:fabric_compositions,id',
            'fabric_type_id' => 'required|exists:fabric_types,id',
            'yarn_count_id' => 'required|exists:yarn_counts,id',
            'fabric_weight_id' => 'required|exists:fabric_weights,id',
            'port_of_landing_id' => 'required|exists:port_of_landings,id',
            'country_of_origin_id' => 'required|exists:country_of_origins,id',
            'port_of_discharge_id' => 'required|exists:port_of_discharges,id',
            'final_destination_id' => 'required|exists:final_destinations,id',
            'delivery_term_id' => 'required|exists:delivery_terms,id',
            'shipment_mode_id' => 'required|exists:shipment_modes,id',
            'payment_term_id' => 'required|exists:payment_terms,id',
            'payment_mode_id' => 'required|exists:payment_modes,id',
            'remarks' => 'nullable|string',
        ]);

        // Add rfq_number generation if needed, e.g., 'RFQ-' . time()
        // $validatedData['rfq_number'] = 'RFQ-' . strtoupper(uniqid());

        RFQs::create($validatedData);

        return redirect()->route('admin.rfq.index')->with('success', 'RFQ created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(RFQs $rfq)
    {
        $rfq->load([
            'itemDescription', 'brand', 'sizeRange', 'color', 
            'fabricComposition', 'fabricType', 'yarnCount', 'fabricWeight',
            'portOfLanding', 'countryOfOrigin', 'portOfDischarge', 'finalDestination',
            'deliveryTerm', 'shipmentMode', 'paymentTerm', 'paymentMode','buyer'
        ]);
        return view('admin.rfq.show', compact('rfq'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(RFQs $rfq)
    {
            $buyer = Buyer::all();
        $itemDescriptions = ItemDescription::all();
        $brands = Brand::all();
        $sizeRanges = SizeRange::all();
        $colors = Color::all();
        $fabricCompositions = FabricComposition::all();
        $fabricTypes = FabricType::all();
        $yarnCounts = YarnCount::all();
        $fabricWeights = FabricWeight::all();
        $portOfLandings = PortOfLanding::all();
        $countryOfOrigins = CountryOfOrigin::all();
        $portOfDischarges = PortOfDischarge::all();
        $finalDestinations = FinalDestination::all();
        $deliveryTerms = DeliveryTerm::all();
        $shipmentModes = ShipmentMode::all();
        $paymentTerms = PaymentTerm::all();
        $paymentModes = PaymentMode::all();

        return view('admin.rfq.edit', compact(
            'rfq', 'itemDescriptions', 'brands', 'sizeRanges', 'colors',
            'fabricCompositions', 'fabricTypes', 'yarnCounts', 'fabricWeights',
            'portOfLandings', 'countryOfOrigins', 'portOfDischarges', 'finalDestinations',
            'deliveryTerms', 'shipmentModes', 'paymentTerms', 'paymentModes', 'buyer'
        ));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, RFQs $rfq)
    {
        $validatedData = $request->validate([
            'buyer_id' => 'required|exists:buyers,id',
            'item_description_id' => 'required|exists:item_descriptions,id',
            'brand_id' => 'nullable|exists:brands,id',
            'size_range_id' => 'required|exists:size_ranges,id',
            'color_id' => 'required|exists:colors,id',
            'fabric_composition_id' => 'required|exists:fabric_compositions,id',
            'fabric_type_id' => 'required|exists:fabric_types,id',
            'yarn_count_id' => 'required|exists:yarn_counts,id',
            'fabric_weight_id' => 'required|exists:fabric_weights,id',
    
            'port_of_landing_id' => 'required|exists:port_of_landings,id',
            'country_of_origin_id' => 'required|exists:country_of_origins,id',
            'port_of_discharge_id' => 'required|exists:port_of_discharges,id',
            'final_destination_id' => 'required|exists:final_destinations,id',
            'delivery_term_id' => 'required|exists:delivery_terms,id',
            'shipment_mode_id' => 'required|exists:shipment_modes,id',
            'payment_term_id' => 'required|exists:payment_terms,id',
            'payment_mode_id' => 'required|exists:payment_modes,id',
            'remarks' => 'nullable|string',
            'status' => 'sometimes|string|in:pending,approved', // Example statuses
        ]);

        $rfq->update($validatedData);

        return redirect()->route('admin.rfq.index')->with('success', 'RFQ updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(RFQ $rfq)
    {
        $rfq->delete();
        return redirect()->route('admin.rfq.index')->with('success', 'RFQ deleted successfully.');
    }
}

