<?php

namespace App\Http\Controllers;

use App\Models\OtherCost;
use Illuminate\Http\Request;

class OtherCostController extends Controller
{
    public function index()
    {
        $otherCosts = OtherCost::all();
        return view("admin.information_library.other_costs.index", compact("otherCosts"));
    }

    public function create()
    {
        return view("admin.information_library.other_costs.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
        
            "is_active" => "boolean",
        ]);

        OtherCost::create($request->all());

        return redirect()->route("admin.other_costs.index")->with("success", "Other Cost created successfully.");
    }

    public function show(OtherCost $otherCost)
    {
        return view("admin.information_library.other_costs.show", compact("otherCost"));
    }

    public function edit(OtherCost $otherCost)
    {
        return view("admin.information_library.other_costs.edit", compact("otherCost"));
    }

    public function update(Request $request, OtherCost $otherCost)
    {
        $request->validate([
            "name" => "required|string|max:255",
          
            "is_active" => "boolean",
        ]);

        $otherCost->update($request->all());

        return redirect()->route("admin.other_costs.index")->with("success", "Other Cost updated successfully.");
    }

    public function destroy(OtherCost $otherCost)
    {
        $otherCost->delete();

        return redirect()->route("admin.other_costs.index")->with("success", "Other Cost deleted successfully.");
    }
}


