<?php

namespace App\Http\Controllers;

use App\Models\KnittingType;
use Illuminate\Http\Request;

class KnittingTypeController extends Controller
{
    public function index()
    {
        $knittingTypes = KnittingType::all();
        return view("admin.information_library.knitting_types.index", compact("knittingTypes"));
    }

    public function create()
    {
        return view("admin.information_library.knitting_types.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "charge" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        KnittingType::create($request->all());

        return redirect()->route("admin.knitting_types.index")->with("success", "Knitting Type created successfully.");
    }

    public function show(KnittingType $knittingType)
    {
        return view("admin.information_library.knitting_types.show", compact("knittingType"));
    }

    public function edit(KnittingType $knittingType)
    {
        return view("admin.information_library.knitting_types.edit", compact("knittingType"));
    }

    public function update(Request $request, KnittingType $knittingType)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "charge" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $knittingType->update($request->all());

        return redirect()->route("admin.knitting_types.index")->with("success", "Knitting Type updated successfully.");
    }

    public function destroy(KnittingType $knittingType)
    {
        $knittingType->delete();

        return redirect()->route("admin.knitting_types.index")->with("success", "Knitting Type deleted successfully.");
    }
}


