<?php

namespace App\Http\Controllers;

use App\Models\Inquiry;
use App\Models\Info\Brand;
use App\Models\Info\ItemDescription;
use App\Models\Info\SizeRange;
use App\Models\Info\Color;
use App\Models\Info\FabricComposition;
use App\Models\Info\FabricType;
use App\Models\Info\YarnCount;
use App\Models\Info\FabricWeight;
use App\Models\Info\PortOfLanding;
use App\Models\Info\CountryOfOrigin;
use App\Models\Info\PortOfDischarge;
use App\Models\Info\FinalDestination;
use App\Models\Info\DeliveryTerm;
use App\Models\Info\ShipmentMode;
use App\Models\Buyer;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

use Illuminate\Http\Request;

class InquiryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $inquiries = Inquiry::with([
            'brand', 'itemDescription', 'sizeRange', 'color',
            'fabricComposition', 'fabricType', 'yarnCount', 'fabricWeight',
            'portOfLanding', 'countryOfOrigin', 'portOfDischarge', 'finalDestination',
            'deliveryTerm', 'shipmentMode', 'buyer'
        ])->latest()->paginate(10);
        
        return view('admin.inquiries.index', compact('inquiries'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // Get all dropdown data
        $buyer = Buyer::all();
        $brands = Brand::all();
        $itemDescriptions = ItemDescription::all();
        $sizeRanges = SizeRange::all();
        $colors = Color::all();
        $fabricCompositions = FabricComposition::all();
        $fabricTypes = FabricType::all();
        $yarnCounts = YarnCount::all();
        $fabricWeights = FabricWeight::all();
        $portOfLandings = PortOfLanding::all();
        $countryOfOrigins = CountryOfOrigin::all();
        $portOfDischarges = PortOfDischarge::all();
        $finalDestinations = FinalDestination::all();
        $deliveryTerms = DeliveryTerm::all();
        $shipmentModes = ShipmentMode::all();

        return view('admin.inquiries.create', compact(
            'brands', 'itemDescriptions', 'sizeRanges', 'colors',
            'fabricCompositions', 'fabricTypes', 'yarnCounts', 'fabricWeights',
            'portOfLandings', 'countryOfOrigins', 'portOfDischarges', 'finalDestinations',
            'deliveryTerms', 'shipmentModes', 'buyer'
        ));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([

            'buyer_id' => 'required|exists:buyers,id',
            'brand_id' => 'required|exists:brands,id',
            'purchase_order_no' => 'required|string|max:255',
            'style_number' => 'required|string|max:255',
            'item_no' => 'required|string|max:255',
            'item_description_id' => 'required|exists:item_descriptions,id',
            'size_range_id' => 'required|exists:size_ranges,id',
            'color_id' => 'required|exists:colors,id',
            'order_quantity' => 'required|integer|min:1',
            'fabric_composition_id' => 'required|exists:fabric_compositions,id',
            'fabric_type_id' => 'required|exists:fabric_types,id',
            'yarn_count_id' => 'required|exists:yarn_counts,id',
            'fabric_weight_id' => 'required|exists:fabric_weights,id',
            'shipment_date' => 'required|date',
            'target_price' => 'nullable|numeric|min:0',
            'port_of_landing_id' => 'required|exists:port_of_landings,id',
            'country_of_origin_id' => 'required|exists:country_of_origins,id',
            'port_of_discharge_id' => 'required|exists:port_of_discharges,id',
            'final_destination_id' => 'required|exists:final_destinations,id',
            'delivery_term_id' => 'required|exists:delivery_terms,id',
            'shipment_mode_id' => 'required|exists:shipment_modes,id',
            'images' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:4096',

        ]);
  
$imageName = null;
if($request->hasFile('images')) {
    $image = $request->file('images');
    $imageName = time().'_'.uniqid().'.'.$image->getClientOriginalExtension();
    $image->move(public_path('inquiries'), $imageName);
}

$validatedData['images'] = $imageName;
  
        Inquiry::create($validatedData);

        return redirect()->route('admin.inquiries.index')->with('success', 'Inquiry created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Inquiry $inquiry)
    {
        $inquiry->load([
            'brand', 'itemDescription', 'sizeRange', 'color',
            'fabricComposition', 'fabricType', 'yarnCount', 'fabricWeight',
            'portOfLanding', 'countryOfOrigin', 'portOfDischarge', 'finalDestination',
            'deliveryTerm', 'shipmentMode', 'buyer'
        ]);
        
        return view('admin.inquiries.show', compact('inquiry'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Inquiry $inquiry)
    {
        // Get all dropdown data
        $buyer = Buyer::all();
        $brands = Brand::all();
        $itemDescriptions = ItemDescription::all();
        $sizeRanges = SizeRange::all();
        $colors = Color::all();
        $fabricCompositions = FabricComposition::all();
        $fabricTypes = FabricType::all();
        $yarnCounts = YarnCount::all();
        $fabricWeights = FabricWeight::all();
        $portOfLandings = PortOfLanding::all();
        $countryOfOrigins = CountryOfOrigin::all();
        $portOfDischarges = PortOfDischarge::all();
        $finalDestinations = FinalDestination::all();
        $deliveryTerms = DeliveryTerm::all();
        $shipmentModes = ShipmentMode::all();

        return view('admin.inquiries.edit', compact(
            'inquiry', 'brands', 'itemDescriptions', 'sizeRanges', 'colors',
            'fabricCompositions', 'fabricTypes', 'yarnCounts', 'fabricWeights',
            'portOfLandings', 'countryOfOrigins', 'portOfDischarges', 'finalDestinations',
            'deliveryTerms', 'shipmentModes', 'buyer'
        ));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Inquiry $inquiry)
    {
        $validatedData = $request->validate([
            'buyer_id' => 'required|exists:buyers,id',
            'brand_id' => 'required|exists:brands,id',
            'purchase_order_no' => 'required|string|max:255',
            'style_number' => 'required|string|max:255',
            'item_no' => 'required|string|max:255',
            'item_description_id' => 'required|exists:item_descriptions,id',
            'size_range_id' => 'required|exists:size_ranges,id',
            'color_id' => 'required|exists:colors,id',
            'order_quantity' => 'required|integer|min:1',
            'fabric_composition_id' => 'required|exists:fabric_compositions,id',
            'fabric_type_id' => 'required|exists:fabric_types,id',
            'yarn_count_id' => 'required|exists:yarn_counts,id',
            'fabric_weight_id' => 'required|exists:fabric_weights,id',
            'shipment_date' => 'required|date',
            'target_price' => 'nullable|numeric|min:0',
            'port_of_landing_id' => 'required|exists:port_of_landings,id',
            'country_of_origin_id' => 'required|exists:country_of_origins,id',
            'port_of_discharge_id' => 'required|exists:port_of_discharges,id',
            'final_destination_id' => 'required|exists:final_destinations,id',
            'delivery_term_id' => 'required|exists:delivery_terms,id',
            'shipment_mode_id' => 'required|exists:shipment_modes,id',
            'images' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:4096',

         
        ]);

          $imageName = $inquiry->images; // existing image

if($request->hasFile('images')) {
    // optionally delete old image file here if needed
    if($imageName && file_exists(public_path('inquiries/'.$imageName))) {
        unlink(public_path('inquiries/'.$imageName));
    }

    $image = $request->file('images');
    $imageName = time().'_'.uniqid().'.'.$image->getClientOriginalExtension();
    $image->move(public_path('inquiries'), $imageName);
}

$validatedData['images'] = $imageName;

        $inquiry->update($validatedData);

        return redirect()->route('admin.inquiries.index')->with('success', 'Inquiry updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Inquiry $inquiry)
    {
        $inquiry->delete();
        return redirect()->route('admin.inquiries.index')->with('success', 'Inquiry deleted successfully.');
    }
}
