<?php
namespace App\Http\Controllers;

use App\Models\InformationLibrary;
use Illuminate\Http\Request;

class InformationLibraryController extends Controller
{
    public function index()
    {
        $items = InformationLibrary::latest()->paginate(10);
        return view('admin.information-library.index', compact('items'));
    }

    public function create()
    {
        return view('admin.information-library.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|string|max:100',
            'category' => 'nullable|string|max:100',
            'name' => 'required|string|max:255',
            'gsm' => 'nullable|string|max:50',
            'wastage_percent' => 'nullable|numeric|min:0|max:100',
            'unit' => 'nullable|string|max:50',
            'rate' => 'nullable|numeric|min:0',
            'description' => 'nullable|string',
            'effective_from' => 'nullable|date',
            'status' => 'required|in:active,inactive',
        ]);

        InformationLibrary::create($request->all());

        return redirect()->route('admin.information-library.index')
                         ->with('success', 'Information item added successfully.');
    }

    public function edit(InformationLibrary $informationLibrary)
    {
        return view('admin.information-library.edit', ['informationLibrary' => $informationLibrary]);
    }

    public function update(Request $request, InformationLibrary $informationLibrary)
    {
        $request->validate([
            'type' => 'required|string|max:100',
            'category' => 'nullable|string|max:100',
            'name' => 'required|string|max:255',
            'gsm' => 'nullable|string|max:50',
            'wastage_percent' => 'nullable|numeric|min:0|max:100',
            'unit' => 'nullable|string|max:50',
            'rate' => 'nullable|numeric|min:0',
            'description' => 'nullable|string',
            'effective_from' => 'nullable|date',
            'status' => 'required|in:active,inactive',
        ]);

        $informationLibrary->update($request->all());

        return redirect()->route('admin.information-library.index')
                         ->with('success', 'Information item updated successfully.');
    }

    public function destroy(InformationLibrary $informationLibrary)
    {
        $informationLibrary->delete();

        return redirect()->route('admin.information-library.index')
                         ->with('success', 'Information item deleted successfully.');
    }
}
