<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\YarnCount;
use Illuminate\Http\Request;

class YarnCountController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        YarnCount::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Yarn Count added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, YarnCount $yarnCount)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $yarnCount->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Yarn Count updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(YarnCount $yarnCount)
    {
        $yarnCount->delete();

        return back()->with('success', 'Yarn Count deleted successfully.');
    }
}
