<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\SizeRange;
use Illuminate\Http\Request;

class SizeRangeController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        SizeRange::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Size Range added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, SizeRange $sizeRange)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $sizeRange->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Size Range updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SizeRange $sizeRange)
    {
        $sizeRange->delete();

        return back()->with('success', 'Size Range deleted successfully.');
    }
}
