<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\ShipmentMode;
use Illuminate\Http\Request;

class ShipmentModeController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        ShipmentMode::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Shipment Mode added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, ShipmentMode $shipmentMode)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $shipmentMode->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Shipment Mode updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ShipmentMode $shipmentMode)
    {
        $shipmentMode->delete();

        return back()->with('success', 'Shipment Mode deleted successfully.');
    }
}
