<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\PortOfLanding;
use Illuminate\Http\Request;

class PortOfLandingController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        PortOfLanding::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Port Of Landing added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PortOfLanding $portOfLanding)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $portOfLanding->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Port Of Landing updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PortOfLanding $portOfLanding)
    {
        $portOfLanding->delete();

        return back()->with('success', 'Port Of Landing deleted successfully.');
    }
}
