<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\PortOfDischarge;
use Illuminate\Http\Request;

class PortOfDischargeController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        PortOfDischarge::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Port Of Discharge added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PortOfDischarge $portOfDischarge)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $portOfDischarge->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Port Of Discharge updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PortOfDischarge $portOfDischarge)
    {
        $portOfDischarge->delete();

        return back()->with('success', 'Port Of Discharge deleted successfully.');
    }
}
