<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\PaymentTerm;
use Illuminate\Http\Request;

class PaymentTermController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        PaymentTerm::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Payment Term added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PaymentTerm $paymentTerm)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $paymentTerm->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Payment Term updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PaymentTerm $paymentTerm)
    {
        $paymentTerm->delete();

        return back()->with('success', 'Payment Term deleted successfully.');
    }
}
