<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\PaymentMode;
use Illuminate\Http\Request;

class PaymentModeController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        PaymentMode::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Payment Mode added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, PaymentMode $paymentMode)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $paymentMode->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Payment Mode updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(PaymentMode $paymentMode)
    {
        $paymentMode->delete();

        return back()->with('success', 'Payment Mode deleted successfully.');
    }
}
