<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\FinalDestination;
use Illuminate\Http\Request;

class FinalDestinationController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        FinalDestination::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Final Destination added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FinalDestination $finalDestination)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $finalDestination->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Final Destination updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FinalDestination $finalDestination)
    {
        $finalDestination->delete();

        return back()->with('success', 'Final Destination deleted successfully.');
    }
}
