<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\FabricWeight;
use Illuminate\Http\Request;

class FabricWeightController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        FabricWeight::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Fabric Weight added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FabricWeight $fabricWeight)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $fabricWeight->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Fabric Weight updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FabricWeight $fabricWeight)
    {
        $fabricWeight->delete();

        return back()->with('success', 'Fabric Weight deleted successfully.');
    }
}
