<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\FabricType;
use Illuminate\Http\Request;

class FabricTypeController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        FabricType::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Fabric Type added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FabricType $fabricType)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $fabricType->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Fabric Type updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FabricType $fabricType)
    {
        $fabricType->delete();

        return back()->with('success', 'Fabric Type deleted successfully.');
    }
}
