<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\FabricComposition;
use Illuminate\Http\Request;

class FabricCompositionController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        FabricComposition::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Fabric Composition added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, FabricComposition $fabricComposition)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $fabricComposition->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Fabric Composition updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(FabricComposition $fabricComposition)
    {
        $fabricComposition->delete();

        return back()->with('success', 'Fabric Composition deleted successfully.');
    }
}
