<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\DeliveryTerm;
use Illuminate\Http\Request;

class DeliveryTermController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        DeliveryTerm::create([
            'name' => $request->name
        ]);

        return back()->with('success', 'Delivery Term added successfully.');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, DeliveryTerm $deliveryTerm)
    {
        $request->validate([
            'name' => 'required|string|max:255'
        ]);

        $deliveryTerm->update([
            'name' => $request->name
        ]);

        return back()->with('success', 'Delivery Term updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(DeliveryTerm $deliveryTerm)
    {
        $deliveryTerm->delete();

        return back()->with('success', 'Delivery Term deleted successfully.');
    }
}
