<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use App\Models\Info\CountryOfOrigin;
use Illuminate\Http\Request;

class CountryOfOriginController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255"
        ]);

        CountryOfOrigin::create([
            "name" => $request->name
        ]);

        return back()->with("success", "Country Of Origin added successfully.");
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, CountryOfOrigin $countryOfOrigin)
    {
        $request->validate([
            "name" => "required|string|max:255"
        ]);

        $countryOfOrigin->update([
            "name" => $request->name
        ]);

        return back()->with("success", "Country Of Origin updated successfully.");
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(CountryOfOrigin $countryOfOrigin)
    {
        $countryOfOrigin->delete();

        return back()->with("success", "Country Of Origin deleted successfully.");
    }
}
