<?php

namespace App\Http\Controllers\Info;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

// Import all models
use App\Models\Info\Brand;
use App\Models\Info\ItemDescription;
use App\Models\Info\SizeRange;
use App\Models\Info\Color; // Current model
use App\Models\Info\FabricComposition;
use App\Models\Info\FabricType;
use App\Models\Info\YarnCount;
use App\Models\Info\FabricWeight;
use App\Models\Info\PortOfLanding;
use App\Models\Info\CountryOfOrigin;
use App\Models\Info\PortOfDischarge;
use App\Models\Info\FinalDestination;
use App\Models\Info\DeliveryTerm;
use App\Models\Info\ShipmentMode;
use App\Models\Info\PaymentTerm;
use App\Models\Info\PaymentMode;

class ColorController extends Controller
{
    public function index()
    {
        $brands = Brand::latest()->paginate(10);
        $descriptions = ItemDescription::latest()->paginate(10);
        $sizeRanges = SizeRange::latest()->paginate(10);
        $colors = Color::latest()->paginate(10); // Current entity data
        $fabricCompositions = FabricComposition::latest()->paginate(10);
        $fabricTypes = FabricType::latest()->paginate(10);
        $yarnCounts = YarnCount::latest()->paginate(10);
        $fabricWeights = FabricWeight::latest()->paginate(10);
        $portOfLandings = PortOfLanding::latest()->paginate(10);
        $countryOfOrigins = CountryOfOrigin::latest()->paginate(10);
        $portOfDischarges = PortOfDischarge::latest()->paginate(10);
        $finalDestinations = FinalDestination::latest()->paginate(10);
        $deliveryTerms = DeliveryTerm::latest()->paginate(10);
        $shipmentModes = ShipmentMode::latest()->paginate(10);
        $paymentTerms = PaymentTerm::latest()->paginate(10);
        $paymentModes = PaymentMode::latest()->paginate(10);

        return view('admin.info.index', compact(
            'brands', 
            'descriptions', 
            'sizeRanges', 
            'colors', 
            'fabricCompositions', 
            'fabricTypes', 
            'yarnCounts', 
            'fabricWeights', 
            'portOfLandings', 
            'countryOfOrigins', 
            'portOfDischarges', 
            'finalDestinations', 
            'deliveryTerms', 
            'shipmentModes', 
            'paymentTerms', 
            'paymentModes'
        ));
    }

    public function store(Request $request)
    {
        $request->validate(['name' => 'required|string|max:255']);
        Color::create(['name' => $request->name]);
        return back()->with('success', 'Color added successfully.');
    }

    public function update(Request $request, Color $color)
    {
        $request->validate(['name' => 'required|string|max:255']);
        $color->update(['name' => $request->name]);
        return back()->with('success', 'Color updated successfully.');
    }

    public function destroy(Color $color)
    {
        $color->delete();
        return back()->with('success', 'Color deleted successfully.');
    }
}

