<?php

namespace App\Http\Controllers;

use App\Models\GarmentAddon;
use Illuminate\Http\Request;

class GarmentAddonController extends Controller
{
    public function index()
    {
        $garmentAddons = GarmentAddon::all();
        return view("admin.information_library.garment_addons.index", compact("garmentAddons"));
    }

    public function create()
    {
        return view("admin.information_library.garment_addons.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "consumption" => "required|numeric",
            "unit" => "required|string|max:50",
            "garment_type" => "required|in:top,bottom,both",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        GarmentAddon::create($request->all());

        return redirect()->route("admin.garment_addons.index")->with("success", "Garment Add-on created successfully.");
    }

    public function show(GarmentAddon $garmentAddon)
    {
        return view("admin.information_library.garment_addons.show", compact("garmentAddon"));
    }

    public function edit(GarmentAddon $garmentAddon)
    {
        return view("admin.information_library.garment_addons.edit", compact("garmentAddon"));
    }

    public function update(Request $request, GarmentAddon $garmentAddon)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "consumption" => "required|numeric",
            "unit" => "required|string|max:50",
            "garment_type" => "required|in:top,bottom,both",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $garmentAddon->update($request->all());

        return redirect()->route("admin.garment_addons.index")->with("success", "Garment Add-on updated successfully.");
    }

    public function destroy(GarmentAddon $garmentAddon)
    {
        $garmentAddon->delete();

        return redirect()->route("admin.garment_addons.index")->with("success", "Garment Add-on deleted successfully.");
    }
}


