<?php

namespace App\Http\Controllers;
use App\Models\BlogCategory;
use App\Models\BlogPost;
use App\Models\BlogComment;
use Illuminate\Http\Request;

class Front extends Controller
{
       public function index(){
    return view('index'); // Ensure that you have the corresponding view
}
 public function about(){
       return view('about');
 }

 public function service(){
       return view('service');
 }
  public function portfolio(){
       return view('portfolio');
 }

public function blog(){
    $posts = BlogPost::latest()->get(); // Make sure to retrieve the posts
    $categories = BlogCategory::all();

    return view('blog', compact('posts', 'categories'));
}



    public function details($slug)
    {
        $post = BlogPost::where('slug', $slug)->first();
        $comments = BlogComment::where('post_id', $post->id)->whereNull('parent_id')->get();
    $totalComments = $post->comments->count() ;


        return view('details', compact('post', 'comments', 'totalComments'));
    }

public function postsByTag($tag)
{
    // Find posts where 'tags' column contains this tag
    $posts = BlogPost::where('tags', 'LIKE', "%$tag%")->get();

    return view('posts-by-tag', compact('posts', 'tag'));
}



 public function contact(){
       return view('contact');
 }


}
