<?php

namespace App\Http\Controllers;

use App\Models\FabricAddon;
use Illuminate\Http\Request;

class FabricAddonController extends Controller
{
    public function index()
    {
        $fabricAddons = FabricAddon::all();
        return view("admin.information_library.fabric_addons.index", compact("fabricAddons"));
    }

    public function create()
    {
        return view("admin.information_library.fabric_addons.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "price" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        FabricAddon::create($request->all());

        return redirect()->route("admin.fabric_addons.index")->with("success", "Fabric Add-on created successfully.");
    }

    public function show(FabricAddon $fabricAddon)
    {
        return view("admin.information_library.fabric_addons.show", compact("fabricAddon"));
    }

    public function edit(FabricAddon $fabricAddon)
    {
        return view("admin.information_library.fabric_addons.edit", compact("fabricAddon"));
    }

    public function update(Request $request, FabricAddon $fabricAddon)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "price" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $fabricAddon->update($request->all());

        return redirect()->route("admin.fabric_addons.index")->with("success", "Fabric Add-on updated successfully.");
    }

    public function destroy(FabricAddon $fabricAddon)
    {
        $fabricAddon->delete();

        return redirect()->route("admin.fabric_addons.index")->with("success", "Fabric Add-on deleted successfully.");
    }
}


