<?php

namespace App\Http\Controllers;

use App\Models\EmailLog;
use Illuminate\Http\Request;

class EmailLogController extends Controller
{
    public function index()
    {
        $emailLogs = EmailLog::with(['document.orderConfirmation', 'sender'])
            ->latest()
            ->paginate(20);

        return view('admin.document-generator.email-logs.index', compact('emailLogs'));
    }

    public function show(EmailLog $emailLog)
    {
        $emailLog->load(['document.orderConfirmation', 'sender']);
        return view('admin.document-generator.email-logs.show', compact('emailLog'));
    }

    public function resend(EmailLog $emailLog)
    {
        $emailLog->update([
            'status' => 'sent',
            'sent_at' => now(),
        ]);

        return back()->with('success', 'Email resent successfully.');
    }
}