<?php

namespace App\Http\Controllers;

use App\Models\DyeingType;
use Illuminate\Http\Request;

class DyeingTypeController extends Controller
{
    public function index()
    {
        $dyeingTypes = DyeingType::all();
        return view("admin.information_library.dyeing_types.index", compact("dyeingTypes"));
    }

    public function create()
    {
        return view("admin.information_library.dyeing_types.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "charge" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        DyeingType::create($request->all());

        return redirect()->route("admin.dyeing_types.index")->with("success", "Dyeing Type created successfully.");
    }

    public function show(DyeingType $dyeingType)
    {
        return view("admin.information_library.dyeing_types.show", compact("dyeingType"));
    }

    public function edit(DyeingType $dyeingType)
    {
        return view("admin.information_library.dyeing_types.edit", compact("dyeingType"));
    }

    public function update(Request $request, DyeingType $dyeingType)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "charge" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $dyeingType->update($request->all());

        return redirect()->route("admin.dyeing_types.index")->with("success", "Dyeing Type updated successfully.");
    }

    public function destroy(DyeingType $dyeingType)
    {
        $dyeingType->delete();

        return redirect()->route("admin.dyeing_types.index")->with("success", "Dyeing Type deleted successfully.");
    }
}


