<?php

namespace App\Http\Controllers;

use App\Models\Cost;
use App\Models\OtherCost;
use Illuminate\Http\Request;

class CostController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $costs = Cost::with('otherCost')->latest()->paginate(10);
        return view('admin.information_library.costs.index', compact('costs'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $otherCosts = OtherCost::all();
        return view('admin.information_library.costs.create', compact('otherCosts'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'amount' => 'required|numeric',
            'other_cost_id' => 'required|exists:other_costs,id',
        ]);

        Cost::create($request->all());

        return redirect()->route('admin.costs.index')
                         ->with('success', 'Cost created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(Cost $cost)
    {
        return view('admin.information_library.costs.show', compact('cost'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Cost $cost)
    {
        $otherCosts = OtherCost::all();
        return view('admin.information_library.costs.edit', compact('cost', 'otherCosts'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Cost $cost)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'amount' => 'required|numeric',
            'other_cost_id' => 'required|exists:other_costs,id',
        ]);

        $cost->update($request->all());

        return redirect()->route('admin.costs.index')
                         ->with('success', 'Cost updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Cost $cost)
    {
        $cost->delete();

        return redirect()->route('admin.costs.index')
                         ->with('success', 'Cost deleted successfully.');
    }
}


