<?php

namespace App\Http\Controllers;

use App\Models\CommercialRate;
use Illuminate\Http\Request;

class CommercialRateController extends Controller
{
    public function index()
    {
        $commercialRates = CommercialRate::all();
        return view("admin.information_library.commercial_rates.index", compact("commercialRates"));
    }

    public function create()
    {
        return view("admin.information_library.commercial_rates.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "percentage" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        CommercialRate::create($request->all());

        return redirect()->route("admin.commercial_rates.index")->with("success", "Commercial Rate created successfully.");
    }

    public function show(CommercialRate $commercialRate)
    {
        return view("admin.information_library.commercial_rates.show", compact("commercialRate"));
    }

    public function edit(CommercialRate $commercialRate)
    {
        return view("admin.information_library.commercial_rates.edit", compact("commercialRate"));
    }

    public function update(Request $request, CommercialRate $commercialRate)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "percentage" => "required|numeric",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $commercialRate->update($request->all());

        return redirect()->route("admin.commercial_rates.index")->with("success", "Commercial Rate updated successfully.");
    }

    public function destroy(CommercialRate $commercialRate)
    {
        $commercialRate->delete();

        return redirect()->route("admin.commercial_rates.index")->with("success", "Commercial Rate deleted successfully.");
    }
}


