<?php
namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Bank;

class BankController extends Controller
{
    public function index()
    {
        $banks = Bank::latest()->paginate(20);
        return view('admin.banks.index', compact('banks'));
    }

    public function create()
    {
        return view('admin.banks.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'account_name' => 'required|string|max:255',
            'account_no'   => 'required|string|max:255',
            'iban'         => 'nullable|string|max:255',
            'swift'        => 'nullable|string|max:100',
            'bank_name'    => 'required|string|max:255',
            'bank_address' => 'nullable|string',
            'correspondent_bank' => 'nullable|string|max:255',
            'correspondent_swift'=> 'nullable|string|max:100',
            'correspondent_account'=> 'nullable|string|max:255',
        ]);

        Bank::create($data);
        return redirect()->route('admin.banks.index')->with('success','Bank saved successfully.');
    }

    public function show(Bank $bank)
    {
        return view('admin.banks.show', compact('bank'));
    }

    public function edit(Bank $bank)
    {
        return view('admin.banks.edit', compact('bank'));
    }

    public function update(Request $request, Bank $bank)
    {
        $data = $request->validate([
            'account_name' => 'required|string|max:255',
            'account_no'   => 'required|string|max:255',
            'iban'         => 'nullable|string|max:255',
            'swift'        => 'nullable|string|max:100',
            'bank_name'    => 'required|string|max:255',
            'bank_address' => 'nullable|string',
            'correspondent_bank' => 'nullable|string|max:255',
            'correspondent_swift'=> 'nullable|string|max:100',
            'correspondent_account'=> 'nullable|string|max:255',
        ]);

        $bank->update($data);
        return redirect()->route('admin.banks.index')->with('success','Bank Detail updated.');
    }

    public function destroy(Bank $bank)
    {
        $bank->delete();
        return back()->with('success','Bank deleted.');
    }
    // public function show(Buyer $buyer)
    // {
    //     $buyer->load('bank');
    //     return view('admin.buyers.show', compact('buyer'));
    // }
    // JSON endpoint used by buyer form AJAX
    public function json(Bank $bank)
    {
        return response()->json($bank);
    }
}
