<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BlogComment;
use App\Models\BlogPost;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

class BlogCommentController extends Controller
{
    public function store(Request $request, $post_id)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'comment' => 'required|string|max:500',
        ]);

        $comment = new BlogComment;
        $comment->post_id = $post_id;
        $comment->name = $request->name;
        $comment->email = $request->email;
        $comment->comment = $request->comment;
        $comment->parent_id = $request->parent_id ?? null;

        $comment->save();
    // Detect AJAX by X-Requested-With header
if ($request->ajax()) {
    if ($request->has('parent_id') && !empty($request->parent_id)) {
        // It's a reply
        return response()->json(['success' => true, 'message' => 'Your reply has been posted!']);
    } else {
        // It's a comment
        return response()->json(['success' => true, 'message' => 'Your comment has been posted!']);
    }
}

    return back()->with('success', 'Your comment has been posted!');
    }
}
