<?php

namespace App\Http\Controllers;

use App\Models\Accessory;
use Illuminate\Http\Request;

class AccessoryController extends Controller
{
    public function index()
    {
        $accessories = Accessory::all();
        return view("admin.information_library.accessories.index", compact("accessories"));
    }

    public function create()
    {
        return view("admin.information_library.accessories.create");
    }

    public function store(Request $request)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "consumption_per_unit" => "required|numeric",
            "default_rate" => "required|numeric",
            "unit" => "required|string|max:50",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        Accessory::create($request->all());

        return redirect()->route("admin.accessories.index")->with("success", "Accessory created successfully.");
    }

    public function show(Accessory $accessory)
    {
        return view("admin.information_library.accessories.show", compact("accessory"));
    }

    public function edit(Accessory $accessory)
    {
        return view("admin.information_library.accessories.edit", compact("accessory"));
    }

    public function update(Request $request, Accessory $accessory)
    {
        $request->validate([
            "name" => "required|string|max:255",
            "consumption_per_unit" => "required|numeric",
            "default_rate" => "required|numeric",
            "unit" => "required|string|max:50",
            "description" => "nullable|string",
            "is_active" => "boolean",
        ]);

        $accessory->update($request->all());

        return redirect()->route("admin.accessories.index")->with("success", "Accessory updated successfully.");
    }

    public function destroy(Accessory $accessory)
    {
        $accessory->delete();

        return redirect()->route("admin.accessories.index")->with("success", "Accessory deleted successfully.");
    }
}


