@include('admin.header') 

<div class="container">
    <div class="row mb-3">
        <div class="col-md-6">
    <h1>Yarn Types</h1>
        </div>
        <div class="col-md-6 text-right">
              <a href="{{ route('admin.yarn_types.create') }}" class="btn btn-primary mb-3"><i class="fas fa-plus"></i> Add New Yarn Type</a>

        </div>
    </div>
    @if (session("success"))
        <div class="alert alert-success">{{ session("success") }}</div>
    @endif
        @if (session('error'))
        <div class="alert alert-danger">
            {{ session('error') }}
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
    <table class="table   table-striped">
        <thead class="bg-dark text-white">
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Price (USD/kg)</th>
                <th>Active</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($yarnTypes as $yarnType)
                <tr>
                    <td>{{ $yarnType->id }}</td>
                    <td>{{ $yarnType->name }}</td>
                    <td>{{ $yarnType->price }}</td>
                    <td>{{ $yarnType->is_active ? "Yes" : "No" }}</td>
                    <td>
                    
                        <a href="{{ route('admin.yarn_types.edit', $yarnType->id) }}" class="btn btn-primary btn-sm"><i class="fas fa-edit"></i> Update</a>
                        <form action="{{ route('admin.yarn_types.destroy', $yarnType->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method("DELETE")
                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')"><i class="fas fa-trash"></i> Remove</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
</div>
</div>

</div>
@include('admin.footer') 


