@include('admin.header') 

<style >label{
    font-weight: 700;
}</style>
<div class="container bg-white p-3">
    <h1>Edit Other Cost</h1>
    <form action="{{ route('admin.other_costs.update', $otherCost->id) }}" method="POST">
        @csrf
        @method("PUT")
        <div class="mb-3">
            <label for="name" class="form-label">Name</label>
            <input type="text" class="form-control" id="name" name="name" value="{{ $otherCost->name }}" required>
        </div>
        <div class="mb-3">
            <label for="default_rate" class="form-label">Default Rate (USD)</label>
            <input type="number" step="0.01" class="form-control" id="default_rate" name="default_rate" value="{{ $otherCost->default_rate }}" required>
        </div>
        <div class="mb-3">
            <label for="unit" class="form-label">Unit</label>
            <input type="text" class="form-control" id="unit" name="unit" value="{{ $otherCost->unit }}" required>
        </div>
        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea class="form-control" id="description" name="description">{{ $otherCost->description }}</textarea>
        </div>
        <div class="mb-3 form-check">
            <input type="checkbox" class="form-check-input" id="is_active" name="is_active" value="1" {{ $otherCost->is_active ? "checked" : "" }}>
            <label class="form-check-label" for="is_active">Active</label>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('admin.other_costs.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@include('admin.footer') 


